/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.spark.common.sampler.node.StackTraceNode;
import me.lucko.spark.lib.asm.ClassReader;
import me.lucko.spark.lib.asm.ClassVisitor;
import me.lucko.spark.lib.asm.Label;
import me.lucko.spark.lib.asm.MethodVisitor;

public final class MethodDisambiguator {
    private final Map<String, ComputedClass> cache = new ConcurrentHashMap<String, ComputedClass>();

    public Optional<MethodDescription> disambiguate(StackTraceNode element) {
        String desc = element.getMethodDescription();
        if (desc != null) {
            return Optional.of(new MethodDescription(element.getMethodName(), desc));
        }
        return this.disambiguate(element.getClassName(), element.getMethodName(), element.getLineNumber());
    }

    public Optional<MethodDescription> disambiguate(String className, String methodName, int lineNumber) {
        ComputedClass computedClass = this.cache.get(className);
        if (computedClass == null) {
            try {
                computedClass = this.compute(className);
            }
            catch (Throwable e) {
                computedClass = ComputedClass.EMPTY;
            }
            this.cache.put(className, computedClass);
        }
        List descriptions = computedClass.descriptionsByName.get((Object)methodName);
        switch (descriptions.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((MethodDescription)descriptions.get(0));
            }
        }
        return Optional.ofNullable((MethodDescription)computedClass.descriptionsByLine.get(lineNumber));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassReader getClassReader(String className) throws IOException {
        String resource = className.replace('.', '/') + ".class";
        try (InputStream is2 = ClassLoader.getSystemResourceAsStream(resource);){
            if (is2 != null) {
                ClassReader classReader2 = new ClassReader(is2);
                return classReader2;
            }
        }
        try {
            Class<?> clazz = Class.forName(className);
            try (InputStream is = clazz.getClassLoader().getResourceAsStream(resource);){
                if (is == null) throw new IOException("Unable to get resource: " + className);
                ClassReader classReader = new ClassReader(is);
                return classReader;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new IOException("Unable to get resource: " + className);
    }

    private ComputedClass compute(String className) throws IOException {
        final ImmutableListMultimap.Builder descriptionsByName = ImmutableListMultimap.builder();
        final HashMap descriptionsByLine = new HashMap();
        MethodDisambiguator.getClassReader(className).accept(new ClassVisitor(458752){

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                final MethodDescription description = new MethodDescription(name, descriptor);
                descriptionsByName.put((Object)name, (Object)description);
                return new MethodVisitor(458752){

                    @Override
                    public void visitLineNumber(int line, Label start) {
                        descriptionsByLine.put(line, description);
                    }
                };
            }
        }, 458752);
        return new ComputedClass((ListMultimap)descriptionsByName.build(), (Map)ImmutableMap.copyOf(descriptionsByLine));
    }

    public static final class MethodDescription {
        private final String name;
        private final String desc;

        private MethodDescription(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String toString() {
            return this.name + this.desc;
        }
    }

    private static final class ComputedClass {
        private static final ComputedClass EMPTY = new ComputedClass((ListMultimap<String, MethodDescription>)ImmutableListMultimap.of(), (Map<Integer, MethodDescription>)ImmutableMap.of());
        private final ListMultimap<String, MethodDescription> descriptionsByName;
        private final Map<Integer, MethodDescription> descriptionsByLine;

        private ComputedClass(ListMultimap<String, MethodDescription> descriptionsByName, Map<Integer, MethodDescription> descriptionsByLine) {
            this.descriptionsByName = descriptionsByName;
            this.descriptionsByLine = descriptionsByLine;
        }
    }
}

